veg_point_trends <- function(veg_data) {
  
  yrs <- sort(unique(year(veg_data$Date)))
  last2surv <- tail(yrs, 2)
  tspan <- diff(range(yrs))
  
  veg_data <- mutate(veg_data, 
                     Year = year(Date)) %>%
    arrange(Point, Year)
  
  # Pivot the data for boxplots
  veg_data_l <- pivot_longer(veg_data,
                             pine_ba:shrubs)
  
  # Find the 5 biggest movers for each variable, and prep for plotting
  veg_data_big <- veg_data %>% 
    filter(Year %in% last2surv) %>%
    group_by(Point) %>%
    arrange(Point, Year) %>%
    summarize(across(pine_ba:shrubs, ~diff(.x)), .groups = "drop") %>%
    mutate(across(pine_ba:shrubs, ~!within_n_mads(.x, n = 2.5)))
  
  #  Pivot the data for boxplots
  veg_data_big_l <- pivot_longer(veg_data_big, pine_ba:shrubs, values_to = "bigmad") %>%
    filter(bigmad) %>%
    mutate(Year = max(last2surv)) %>%
    left_join(veg_data_l, by = c("Point", "Year", "name"))

  veg_data_l <- left_join(veg_data_l, 
                    select(veg_data_big_l, Point:bigmad), 
                    by = c("Point", "name"))
  
  p <- 
    ggplot(veg_data_l, aes(Year, value, group = Point)) +
    geom_line(data = filter(veg_data_l, is.na(bigmad)), color = "gray50", alpha = 0.5) +
    geom_line(data = filter(veg_data_l, !is.na(bigmad)), color = "red", lwd = 1, alpha = 0.5) +
    facet_wrap(~name, scales="free_y", nrow=3) +
    labs(y = "Measurement",
         title = "Vegetation trends by survey point",
         subtitle = paste("Points with relatively unusual changes from", 
                          paste(last2surv, collapse = " - "),
                          "highlighted for closer inspection")) +
    scale_x_continuous(limits = c(NA, max(yrs) + tspan / 5)) +
    theme_bw() +
    geom_text_repel(data = veg_data_big_l, aes(label = Point),
                     color = "red", nudge_x = tspan / 10, size = 3)
  p
}
