veg_boxplots <- function(veg_data, year = NULL) {
  if (!is.null(year)) rec_yr <- year
  else rec_yr <- max(year(veg_data$Date))
  yr_dat <- filter(veg_data, year(Date) == rec_yr)
  if (nrow(yr_dat) == 0) stop("No data found for ", rec_yr, call. = FALSE)
  
  # Pivot the data for boxplots
  yr_dat_long <- pivot_longer(yr_dat,
                              pine_ba:shrubs)
  
  p <- ggplot(yr_dat_long, aes(y = value)) + 
    geom_boxplot() + 
    facet_wrap(~name, scales="free_y", nrow=3) +
    ggtitle(paste("Vegetation measurements across all sites in", rec_yr)) +
    labs(y = "Measurement") +
    theme_bw()
  p
}