table_occupancy <- function(occu_fit, out_file = NULL) {
  est <- occu_fit@estimates@estimates
  tabs <- lapply(est, function(x){
    ci <- confint(x)
    ci <- ci[apply(ci, 1, function(r) !all(is.na(r))), ]
    nul <- capture.output(s <- summary(x))
    out <- data.frame(Model = x@name,
                      Parameter = tolower(gsub("\\(|\\)", "", rownames(s))),
                      s,
                      lower = unname(ci[, 1]), 
                      upper = unname(ci[, 2]))
    rownames(out) <- NULL
    out <- mutate(out, 
                  across(all_of(c("Estimate", "SE", "z", "lower", "upper")), round, 2),
                  across(starts_with("P..."), round, 3),
                  `CI (95%)` = paste(format(lower, nsmall = 2), format(upper, nsmall = 2), sep = " - ")) %>%
      select(Model, Parameter, Estimate, SE, `CI (95%)`, z, `P-value` = starts_with("P..."))
    
    out
  })
  out <- bind_rows(tabs)
  html_tbl <- kbl(out) %>%
    kable_styling(bootstrap_options = c("striped", "hover", "condensed", "responsive"), full_width = FALSE)
  if (!is.null(out_file)) save_kable(html_tbl, out_file)
  html_tbl
}