process_pre2020_veg_data <- function(pre2020_xls) {
  
  years <- excel_sheets(pre2020_xls) %>%
    str_extract("^[:digit:]{4}$")
  message("Reading in vegetation data for ", oxfordize(years))
  
  # Get the data
  dat <- lapply(years, function(yr) {
    tmp <- read_excel(pre2020_xls, sheet = yr,
                      col_names = c("Point", "Sector", "Date", "pine_ba",
                                    "hard_ba", "pdbh1", "pdbh2", "pdbh3",
                                    "pdbh4", "pdbh5", "snag_dir", "snag_l25",
                                    "snag_l50", "snag_l100", "snag_g100",
                                    "canopy", "grass", "forb", "woody", 
                                    "bare", "litter", "shrubs", "n_veg"),
                      col_types = c(rep("text", 3), rep("numeric", 7), 
                                    "text", rep("numeric", 12), "skip"),
                      skip = 1) %>%
      mutate(Point = toupper(Point)) %>%
      group_by(Point) %>%
      # Canopy and shrubs collected on 1/2 of transects so adjust
      summarize(Date = as.Date(median(as.integer(Date), na.rm = TRUE), origin = "1899-12-30"),
                pine_ba = mean(pine_ba, na.rm = TRUE),
                hard_ba = mean(hard_ba, na.rm = TRUE),
                pine_dbh = mean(rbind(pdbh1, pdbh2, pdbh3, pdbh4, pdbh5), na.rm = TRUE),
                snags = sum(rbind(snag_l25, snag_l50), na.rm = TRUE),
                canopy = mean(canopy / (n_veg/2), na.rm = TRUE),
                grass = mean(grass / n_veg, na.rm = TRUE),
                forb = mean(forb / n_veg, na.rm = TRUE),
                woody = mean(woody / n_veg, na.rm = TRUE),
                bare = mean(bare / n_veg, na.rm = TRUE),
                litter = mean(litter / n_veg, na.rm = TRUE),
                shrubs = mean(shrubs / (n_veg/2), na.rm = TRUE),
                .groups = "drop") 
    tmp
  })
  
  # Compile data and remove the limited Loggerhead Shrike data
  dat <- bind_rows(dat) 
  return(dat)
  
}