plot_effort <- function(bird_data, highlight = NULL) {
  
  p <- ggplot(bird_data, aes(DateTime, Point, color = Species)) +
    geom_point()

    if (!is.null(highlight)) {
    odd <- left_join(highlight, bird_data, by = c("Point", "Species"))
    p <- p + geom_point(data = odd, shape = 21, fill = NA, color = "black", stroke = 1.5) 
  }
  
 p <- p +
     facet_wrap(~ year(DateTime), scales = "free_x") +
    labs(x = "Date") +
    scale_color_brewer(type = "qual", palette = "Dark2") +
    theme_bw()
  p
}