flag_odd_effort <- function(bird_data, expected_effort, year = NULL) {
  if (!is.null(year)) rec_yr <- year
  else rec_yr <- max(year(bird_data$DateTime))
  effort_dat <- filter(bird_data, year(DateTime) == rec_yr)
  if (nrow(effort_dat) == 0) stop("No data found for ", rec_yr, call. = FALSE)
  effort_tab <- with(effort_dat, table(Point, Species))
  effort_spp <- attr(effort_tab, "dimnames")$Species
  if (!all(names(expected_effort) %in% effort_spp)) {
    warning("Found only the following species in the data for ", rec_yr,
            ": ", paste(effort_spp, collapse = ", "), 
            "\nProceeded with the assessment for these species.", call. = FALSE)
    expected_effort <- expected_effort[effort_spp]
  }
  # Find effort inconsistent with expectations
  odd <- apply(effort_tab, 1, function(r) r != expected_effort) %>% t() %>%
    as.table() %>% as.data.frame(responseName = "Flag") %>% filter(Flag) %>% select(-Flag)
  if (nrow(odd) > 0) {
    message("Survey effort at the following points deviated from expectation in ", rec_yr)
    print(arrange(odd, Species, Point))
    p <- plot_effort(effort_dat, highlight = odd)
    print(p)
    message("Here's the potentially offending data")
    out <- left_join(odd, effort_dat, by = c("Point", "Species")) %>%
      arrange(Species, Point)
    return(out)
  } else {
    p <- plot_effort(effort_dat)
    print(p)
    message("All survey data met expectations in ", rec_yr)
    invisible(NULL)
  }
}